<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Payment extends Model 
{

    protected $table = 'payments';
    public $timestamps = true;
    protected $fillable = array('user_id', 'booking_id', 'total_amount');

    public function user()
    {
        return $this->hasOne('App\Models\User', 'user_id');
    }

    public function bookingInfo()
    {
        return $this->hasOne('App\Models\BookingInfo', 'booking_id');
    }

}